using System;
using System.Drawing;
using System.Collections;
using Microsoft.DirectX;
using Microsoft.DirectX.DirectInput;

using DarkStrideToolbox;


namespace DarkStride.StellarLanes.SharedDLL
{
	public class Window_Popup
	{
		#region Properties
		private Vector2 m_vPosToDrawAt = Vector2.Empty;
		private string m_sGraphicKey = "";
		private ArrayList m_oProperties = null;
		private Item m_oItem = null;

		private DarkStrideToolbox.DSInputWrapper.CallbackMouseMoved m_oMouseMovedCallback = null;
		#endregion

		public Window_Popup()
		{
		}
		public void Dispose()
		{
			Globals.Inst().GameEngine.RenderAfterForms -= new EventHandler( Render );
			Globals.Inst().GameEngine.DirectInput.UnRegisterDelegate_MouseMoved( m_oMouseMovedCallback );
		}

		public void Display( Vector2 vPosToDrawAt,Item oItem,string sGraphicKey,ArrayList oProperties )
		{
			//int nPropCount = 0;
			System.Drawing.Rectangle oRect = System.Drawing.Rectangle.Empty;


            if (sGraphicKey.Length == 0)
            {
                sGraphicKey = "FloatingLoot2";
            }

			//Save our data
			m_oProperties = oProperties;
			m_vPosToDrawAt = vPosToDrawAt;
			m_sGraphicKey = sGraphicKey;
			m_oItem = oItem;

			//Adjust our location to draw at so we are always on screen
			oRect = GetBorderRect();
			m_vPosToDrawAt.X = DSMisc.Max( 0,m_vPosToDrawAt.X );
			m_vPosToDrawAt.Y = DSMisc.Max( 0,m_vPosToDrawAt.Y );
			m_vPosToDrawAt.X = DSMisc.Min( m_vPosToDrawAt.X,Globals.Inst().GameEngine.ScreenWidth - oRect.Width );
			m_vPosToDrawAt.Y = DSMisc.Min( m_vPosToDrawAt.Y,Globals.Inst().GameEngine.ScreenHeight - oRect.Height );

			//Setup the event handling
			Globals.Inst().GameEngine.RenderAfterForms += new EventHandler( Render );
			m_oMouseMovedCallback = new DSInputWrapper.CallbackMouseMoved( MouseMoved );
			Globals.Inst().GameEngine.DirectInput.RegisterDelegate_MouseMoved( m_oMouseMovedCallback );
		}


		private bool MouseMoved( Vector2 vCurPos,MouseState oMouseStateData,bool[] baButtons )
		{
			return( false );
		}
		private void Render( object sender, System.EventArgs e )
		{
			int nBorder = 8;
			int nYPos = (int)( m_vPosToDrawAt.Y + GobConstants.m_cBORDER_GRAY_TOPSIZE + nBorder );
			double nTemp = 0;
			RenderSettings oRenderSettings = null;
			ItemSpecialTrait oLoopTrait = null;
			Vector2 vSpaceAvail = new Vector2( 60,60 );
			System.Drawing.Rectangle oPeiceArea = System.Drawing.Rectangle.Empty;
			System.Drawing.Rectangle oTextArea = System.Drawing.Rectangle.Empty;
			Microsoft.DirectX.Direct3D.Font oSLFont = null;
			LoadedTexture oLoadedTexture = null;


			//Draw a fancy border
			Globals.Inst().GameEngine.RenderBorder( GetBorderRect(),GobConstants.m_cBORDER_GRAY );

			//Draw the peice
			oLoadedTexture = DSResourceManager.GetGlobalInstance().GetLoadedTexture( m_sGraphicKey );
			oPeiceArea = new System.Drawing.Rectangle( 
									(int)m_vPosToDrawAt.X + 25,(int)m_vPosToDrawAt.Y + 28,
									(int)vSpaceAvail.X,(int)vSpaceAvail.Y );

			//Draw a background
			System.Drawing.Color oBackColor = GraphicConstants.m_cBASICCOLOR;
			oBackColor = System.Drawing.Color.FromArgb( oBackColor.R+50,oBackColor.G+50,oBackColor.B+50 );
			Globals.Inst().GameEngine.RenderRect2D( oPeiceArea,oBackColor.ToArgb() );

			//Get the ratio setup right
			if( oLoadedTexture.Size.X > oLoadedTexture.Size.Y && oLoadedTexture.Size.X > vSpaceAvail.X )
			{
				nTemp = oLoadedTexture.Size.Y / oLoadedTexture.Size.X;
				oPeiceArea.Height = (int)( (double)oPeiceArea.Height * nTemp );
			}
			else if( oLoadedTexture.Size.Y > oLoadedTexture.Size.X && oLoadedTexture.Size.Y > vSpaceAvail.Y )
			{
				nTemp = oLoadedTexture.Size.X / oLoadedTexture.Size.Y;
				oPeiceArea.Width = (int)( (double)oPeiceArea.Width * nTemp );
			}
			//Now center it
			oPeiceArea.X += (int)( ( vSpaceAvail.X - oPeiceArea.Width ) / 2.0 );
			oPeiceArea.Y += (int)( ( vSpaceAvail.Y - oPeiceArea.Height ) / 2.0 );
			//Now draw it
			oRenderSettings = new RenderSettings( 
				oPeiceArea,Globals.Inst().OurShip,
				new Vector2(0,0),1,enumRenderType.Modules,
				enumEditorObject.Unassigned,enumGameScreen.Editor,   
				0,System.Drawing.Color.White );
			if( m_oItem.GetType().BaseType == typeof( Chassis ) )
			{
				oRenderSettings.RenderType = enumRenderType.Topside;
			}
			m_oItem.RenderForEditor3D( oPeiceArea,oRenderSettings );

			//Draw the name
			oSLFont = DSResourceManager.GetGlobalInstance().GetFont( GraphicConstants.m_cSLFONT );
			Globals.Inst().GameEngine.RenderText( oSLFont,
							m_vPosToDrawAt.X + 100,nYPos,System.Drawing.Color.White,m_oItem.Name );
			nYPos += 40;

			/*//Display class and level
			Globals.Inst().GameEngine.RenderText( oAreaToDrawAt.X + 120,oAreaToDrawAt.Y + 80,
				System.Drawing.Color.White,
				m_nItemClass.ToString() );
			Globals.Inst().GameEngine.RenderText( oAreaToDrawAt.X + 120,oAreaToDrawAt.Y + 100,
				System.Drawing.Color.White,
				m_nItemLevel.ToString() );*/

			//Show the special abilities
			for( int i=0 ; i<m_oItem.SpecialTraits.Count ; i++ )
			{
				oLoopTrait = (ItemSpecialTrait)m_oItem.SpecialTraits[ i ];

				Globals.Inst().GameEngine.RenderText(
					m_vPosToDrawAt.X + 120,nYPos,
					System.Drawing.Color.LightBlue,
					oLoopTrait.GetTraitDescription() + " - " + oLoopTrait.Value.ToString( "0.00" ) );
				nYPos += 20;
			}

			//Now add the rectangle descriptions we have
			for( int i=0 ; i<m_oProperties.Count ; i++ )
			{
				Globals.Inst().GameEngine.RenderText(m_vPosToDrawAt.X + 120,nYPos,
					System.Drawing.Color.LightBlue,(string)m_oProperties[ i ] );
				nYPos += 20;
			}
		}

		private System.Drawing.Rectangle GetBorderRect()
		{
			int nBorder = 8;
			int nHeight = 162;
			System.Drawing.Rectangle oRect = System.Drawing.Rectangle.Empty;

			nHeight = DSMisc.Max( nHeight,
				GobConstants.m_cBORDER_GRAY_TOPSIZE + 
				GobConstants.m_cBORDER_GRAY_BOTTOMSIZE + 
				nBorder * 2 + 
				50 + //for name and such
				( m_oProperties.Count + m_oItem.SpecialTraits.Count ) * 20 );

			oRect = new Rectangle( (int)m_vPosToDrawAt.X,(int)m_vPosToDrawAt.Y,300,nHeight );

			return( oRect );
		}
	}
}
